//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.Windows.Forms;
using System.ServiceModel;
using Microsoft.ServiceBus;

namespace ServiceModelEx.ServiceBus
{
   partial class EndpointViewControl : NodeViewControl
   {
      string m_Address;

      public EndpointViewControl()
      {
         InitializeComponent();
      }
      public override void Refresh(ServiceBusNode node,TransportClientEndpointBehavior credential)
      {
         base.Refresh(node,credential);

         m_Address = Address;

            // Kana nie udostpnia odpowiedniego protokou transportowego - zawsze naley stosowa protok HTTP lub HTTPS
         m_Address = m_Address.Replace(@"sb://",@"[transport]://");

         m_AddressLabel.Text = m_Address;
         TrimLable(m_AddressLabel,69);
      }
      protected override void OnCopy(object sender,EventArgs e)
      {
         Clipboard.SetText(m_Address);
      }
   }
}
